-- Armed boat based on the castle class OPV 

mount_vfs_model_path	(current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures/")


GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "OPV-01"
GT.visual.shape_dstr = ""

GT.animation_arguments.water_propeller = 65; 

GT.life = 180;
GT.mass = 8715
GT.max_velocity = 36.4333
GT.race_velocity = 15.4333
GT.economy_velocity = 12.2889
GT.economy_distance = 11112e+007
GT.race_distance = 2778e+006
GT.shipLength = 81.4 --172.8
GT.Width = 21 --15
GT.Height = 2.2 --37.2
GT.Length = 81 --172.8
GT.DeckLevel = 4.609
GT.X_nose = 35.918
GT.X_tail = -36.214
GT.Tail_Width = 2
GT.Gamma_max = 0.35
GT.Om = 0.59
GT.speedup = 0.41779
GT.R_min = 345.6
GT.distFindObstacles = 7568.4

GT.airWeaponDist = 5000
GT.airFindDist = 7000

--GT.Landing_Point = {-24.467, 3.191, 0.0};

GT.exhaust = {
	[1] = { size = 0.2 , pos = { -4.577, 15.833, -0.733 } },
	[2] = { size = 0.3 , pos = { -4.577, 15.833, -0.733 } },
}



GT.DM = {
    { area_name = "NOSE_R_01", 				area_arg = 70, area_life = 150, area_fire = { connector = "FIRE_NOSE_R_01", size = 0.5}},
	{ area_name = "NOSE_R_02", 				area_arg = 94, area_life = 150, area_fire = { connector = "FIRE_NOSE_R_02", size = 0.5}},
	{ area_name = "CENTER_R_01", 			area_arg = 71, area_life = 150, area_fire = { connector = "FIRE_CENTER_R_01", size = 0.5}},
	{ area_name = "CENTER_R_02", 			area_arg = 96, area_life = 150, area_fire = { connector = "FIRE_CENTER_R_02", size = 0.5}},
    { area_name = "BACK_R", 				area_arg = 72, area_life = 300, area_fire = { connector = "FIRE_BACK_R", size = 0.5}},
	
    { area_name = "NOSE_L_01", 				area_arg = 73, area_life = 150, area_fire = { connector = "FIRE_NOSE_L_01", size = 0.5}},
	{ area_name = "NOSE_L_02", 				area_arg = 95, area_life = 150, area_fire = { connector = "FIRE_NOSE_L_02", size = 0.5}},
    { area_name = "CENTER_L_01", 			area_arg = 74, area_life = 150, area_fire = { connector = "FIRE_CENTER_L_01", size = 0.5}},
	{ area_name = "CENTER_L_02", 			area_arg = 97, area_life = 150, area_fire = { connector = "FIRE_CENTER_L_02", size = 0.5}},
	{ area_name = "CENTER_L_03", 			area_arg = 98, area_life = 150},
    { area_name = "BACK_L", 				area_arg = 75, area_life = 300, area_fire = { connector = "FIRE_BACK_L", size = 0.5}},
	
	{ area_name = "PALUBA_NOSE",			area_arg = 76, area_life = 100, area_fire = { connector = "FIRE_PALUBA_NOSE", size = 0.8}},
	{ area_name = "PALUBA_MIDLE_01",		area_arg = 77, area_life = 100, area_fire = { connector = "FIRE_PALUBA_MIDLE_01", size = 0.8}},
	{ area_name = "PALUBA_MIDLE_02",		area_arg = 92, area_life = 100, area_fire = { connector = "FIRE_PALUBA_MIDLE_02", size = 0.8}},
	{ area_name = "PALUBA_BACK_01", 		area_arg = 78, area_life = 100, area_fire = { connector = "FIRE_PALUBA_BACK_01", size = 0.8}},
	{ area_name = "PALUBA_BACK_02", 		area_arg = 93, area_life = 100, area_fire = { connector = "FIRE_PALUBA_BACK_02", size = 0.8}},
	
	{ area_name = "BACK", 					area_arg = 79, area_life = 100},
	{ area_name = "RUBKA",					area_arg = 80, area_life = 100, area_fire = { connector = "FIRE_RUBKA", size = 0.8}},
	{ area_name = "MACHTA",					area_arg = 81, area_life = 100},
	{ area_name = "TOWER",					area_arg = 82, area_life = 100},

	
}

--
--Weapons

GT.WS = {};
GT.WS.maxTargetDetectionRange = 10000;
GT.WS.radar_type = 104; -- short range
GT.WS.radar_rotation_type = 1;
GT.WS.searchRadarMaxElevation = math.rad(45);
--

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.SS_t.OSA_tracker);
GT.WS[ws].pos = {-8.083, -12.698, 5.934};
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(-300);
local osa_trackers_BR = {{{"self", ws}}};

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.SS_t.OSA_tracker);
GT.WS[ws].pos = {-8.083, 12.698, -5.934};
GT.WS[ws].board = 2;
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(300);
local osa_trackers_BL = {{{"self", ws}}};



--Bow Seacat
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Seacat_V_BL )
GT.WS[ws].area = 'PALUBA_NOSE' 
GT.WS[ws].center = 'GWS-21_BL'
GT.WS[ws].drawArgument1 = 51 
GT.WS[ws].drawArgument2 = 52
GT.WS[ws].LN[1].depends_on_unit = osa_trackers_BL;
GT.WS[ws].LN[1].BR = {
						{connector_name = 'Seacat_V_Point_01'},
						{connector_name = 'Seacat_V_Point_02'},
						{connector_name = 'Seacat_V_Point_03'},
						{connector_name = 'Seacat_V_Point_04'},					
					};
					
--Stern Seacat
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_Seacat_V_BR )
GT.WS[ws].area = 'PALUBA_BACK_01'
GT.WS[ws].center = 'GWS-21_BR'
GT.WS[ws].drawArgument1 = 49 
GT.WS[ws].drawArgument2 = 50 
GT.WS[ws].LN[1].depends_on_unit = osa_trackers_BR;
GT.WS[ws].LN[1].BR = {
						{connector_name = 'Seacat_V_Point_05'},
						{connector_name = 'Seacat_V_Point_06'},
						{connector_name = 'Seacat_V_Point_07'},
						{connector_name = 'Seacat_V_Point_08'},					
					};


ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_07'
GT.WS[ws].drawArgument1 = 42
GT.WS[ws].drawArgument2 = 43
GT.WS[ws].angles = {
					{math.rad(180), math.rad(-1), math.rad(-5), math.rad(70)},
					};
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN.BR[1].connector_name = 'POINT_GUN_07'
__LN.fireAnimationArgument = 125;

ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_06'
GT.WS[ws].drawArgument1 = 40
GT.WS[ws].drawArgument2 = 41
GT.WS[ws].angles = {
					{math.rad(1), math.rad(180), math.rad(-5), math.rad(70)},
					};
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.machinegun_12_7_M2);
__LN.BR[1].connector_name = 'POINT_GUN_06'
__LN.fireAnimationArgument = 124;

--

GT.Name = "OPV_01"
GT.DisplayName = _("Armed vessel seacats")
GT.Rate = 700

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR",},
               
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="no";
GT.mapclasskey = "P0091000067";
GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,wsType_GenericLightArmoredShip,
					"low_reflection_vessel",
                    "Light armed ships",
					"Corvettes",
				};
GT.Categories = {
					{name = "Armed Ship"},
				};


add_surface_unit(GT)
